"""
HB_LoopCut V1.2

Last Modified: Oct/11/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_LoopCut
Description-US: Activates Edge-mode and sets up Knife-Tool to do loopcuts

Activates Edge-mode and sets up Knife-Tool to do loopcuts. Also Snapping will be disabled.

Video Tutorial:
https://youtu.be/Ki6I9sRdeUU?t=12m30s

Name-DE: HB_LoopCut
Description-DE: Aktiviert Kanten Modus und Messerwerkzeug mit Loop Modus

ChangeLog:
Jun/11/2015 V1.0
- Release Version

Apr/25/2016 V1.1
- R18 Support

Oct/11/2018 V1.2
- New Highres Icon

"""

import c4d
from c4d import documents, plugins
  
def tool():
    return c4d.plugins.GetToolData(doc, doc.GetAction())

def main():

    c4d.CallCommand(16351) # Edges
    c4d.CallCommand(431000165) # Loop/Path Cutter
    
    
    
    tool()[c4d.MDATA_KNIFEPATH_MODE]=0
    tool()[c4d.MDATA_KNIFEPATH_SELECTED]=False
    tool()[c4d.MDATA_KNIFEPATH_SELECT_CUT]=False
    tool()[c4d.MDATA_KNIFEPATH_CUTPOLYS]=True
    tool()[c4d.MDATA_KNIFEPATH_INTERACTION_SYMETRY]=False
    

    

    #Snapping
    if (c4d.IsCommandChecked(440000121)):
        c4d.CallCommand(440000121) # Snapping on
   




if __name__=='__main__':
    main()
    c4d.EventAdd()